/**
 * \file: errmemd_erase.c
 *
 * Implementation of the main function of the error memory daemon.
 *
 * This file implements the erase function of the error memory daemon.
 *
 * \component: errmemd
 *
 * \author: veeraiyan chidambaram (Veeraiyan Chidambaram@in.bosch.com)
 *
 * \copyright (c) 2013 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 * <history item>
 */

#include "errmem_erase.h"
#include <string.h>
#include <errno.h>
#include <syslog.h>

int errmem_lib_erase(ErrmemBackend_t* cur)
{
    int sh;
    int rc = 0;

    /* open the session */
    sh = errmem_backend_open_session();

    if(sh < 0)
        return sh;

    if(cur->get_nr)
    {
        rc = errmem_backend_erase(sh, cur->get_nr(cur));
    }

    /* close the session */
    errmem_backend_close_session(sh);

    return rc;
}
